/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.internal.ads.zzkt;
import com.google.android.gms.internal.ads.zznf;
import com.google.android.gms.internal.ads.zzng;
import com.google.android.gms.internal.ads.zzsk;
import com.google.android.gms.internal.ads.zzsy;
import java.util.Arrays;
import java.util.Comparator;
import java.util.UUID;

public final class zzne
implements Parcelable,
Comparator<zza> {
    private final zza[] zzazf;
    private int zzafx;
    public final int zzazg;
    public static final Parcelable.Creator<zzne> CREATOR = new zznf();

    public zzne(zza ... zzaArray) {
        this(true, zzaArray);
    }

    private zzne(boolean bl, zza ... zzaArray) {
        zzaArray = (zza[])zzaArray.clone();
        Arrays.sort(zzaArray, this);
        for (int i = 1; i < zzaArray.length; ++i) {
            if (!zzaArray[i - 1].uuid.equals(zzaArray[i].uuid)) continue;
            String string2 = String.valueOf(zzaArray[i].uuid);
            throw new IllegalArgumentException(new StringBuilder(25 + String.valueOf(string2).length()).append("Duplicate data for uuid: ").append(string2).toString());
        }
        this.zzazf = zzaArray;
        this.zzazg = zzaArray.length;
    }

    zzne(Parcel parcel) {
        this.zzazf = (zza[])parcel.createTypedArray(zza.CREATOR);
        this.zzazg = this.zzazf.length;
    }

    public final zza zzap(int n) {
        return this.zzazf[n];
    }

    public final int hashCode() {
        if (this.zzafx == 0) {
            this.zzafx = Arrays.hashCode(this.zzazf);
        }
        return this.zzafx;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return Arrays.equals(this.zzazf, ((zzne)object).zzazf);
    }

    public final int describeContents() {
        return 0;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        parcel.writeTypedArray((Parcelable[])this.zzazf, 0);
    }

    @Override
    public final /* synthetic */ int compare(Object object, Object object2) {
        zza zza2 = (zza)object2;
        zza zza3 = (zza)object;
        if (zzkt.zzarg.equals(zza3.uuid)) {
            if (zzkt.zzarg.equals(zza2.uuid)) {
                return 0;
            }
            return 1;
        }
        return zza3.uuid.compareTo(zza2.uuid);
    }

    public static final class zza
    implements Parcelable {
        private int zzafx;
        private final UUID uuid;
        private final String mimeType;
        private final byte[] data;
        public final boolean zzazh;
        public static final Parcelable.Creator<zza> CREATOR = new zzng();

        public zza(UUID uUID, String string2, byte[] byArray) {
            this(uUID, string2, byArray, false);
        }

        private zza(UUID uUID, String string2, byte[] byArray, boolean bl) {
            this.uuid = zzsk.checkNotNull(uUID);
            this.mimeType = zzsk.checkNotNull(string2);
            this.data = zzsk.checkNotNull(byArray);
            this.zzazh = false;
        }

        zza(Parcel parcel) {
            this.uuid = new UUID(parcel.readLong(), parcel.readLong());
            this.mimeType = parcel.readString();
            this.data = parcel.createByteArray();
            this.zzazh = parcel.readByte() != 0;
        }

        public final boolean equals(Object object) {
            if (!(object instanceof zza)) {
                return false;
            }
            if (object == this) {
                return true;
            }
            zza zza2 = (zza)object;
            return this.mimeType.equals(zza2.mimeType) && zzsy.zza(this.uuid, zza2.uuid) && Arrays.equals(this.data, zza2.data);
        }

        public final int hashCode() {
            if (this.zzafx == 0) {
                int n = this.uuid.hashCode();
                n = n * 31 + this.mimeType.hashCode();
                this.zzafx = n = n * 31 + Arrays.hashCode(this.data);
            }
            return this.zzafx;
        }

        public final int describeContents() {
            return 0;
        }

        public final void writeToParcel(Parcel parcel, int n) {
            parcel.writeLong(this.uuid.getMostSignificantBits());
            parcel.writeLong(this.uuid.getLeastSignificantBits());
            parcel.writeString(this.mimeType);
            parcel.writeByteArray(this.data);
            parcel.writeByte((byte)(this.zzazh ? 1 : 0));
        }
    }
}

