/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.internal.ads.zzaci;
import com.google.android.gms.internal.ads.zzact;
import com.google.android.gms.internal.ads.zzare;
import com.google.android.gms.internal.ads.zzaxa;
import com.google.android.gms.internal.ads.zzazk;
import com.google.android.gms.internal.ads.zzazu;
import com.google.android.gms.internal.ads.zzazy;
import com.google.android.gms.internal.ads.zzbdg;
import com.google.android.gms.internal.ads.zzbfu;
import com.google.android.gms.internal.ads.zzbfv;
import com.google.android.gms.internal.ads.zzyr;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@zzare
public final class zzbgf
extends zzbfu {
    private static final Set<String> zzeig = Collections.synchronizedSet(new HashSet());
    private static final DecimalFormat zzeih = new DecimalFormat("#,###");
    private File zzeii;
    private boolean zzeij;

    public zzbgf(zzbdg zzbdg2) {
        super(zzbdg2);
        File file = this.mContext.getCacheDir();
        if (file == null) {
            zzaxa.zzep((String)"Context.getCacheDir() returned null");
            return;
        }
        this.zzeii = new File(file, "admobVideoStreams");
        if (!this.zzeii.isDirectory() && !this.zzeii.mkdirs()) {
            String string2 = String.valueOf(this.zzeii.getAbsolutePath());
            zzaxa.zzep((String)(string2.length() != 0 ? "Could not create preload cache directory at ".concat(string2) : new String("Could not create preload cache directory at ")));
            this.zzeii = null;
            return;
        }
        if (!this.zzeii.setReadable(true, false) || !this.zzeii.setExecutable(true, false)) {
            String string3 = String.valueOf(this.zzeii.getAbsolutePath());
            zzaxa.zzep((String)(string3.length() != 0 ? "Could not set cache file permissions at ".concat(string3) : new String("Could not set cache file permissions at ")));
            this.zzeii = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzex(String string2) {
        int n;
        Object object;
        int n2;
        Object object2;
        block41: {
            int n3;
            if (this.zzeii == null) {
                this.zza(string2, null, "noCacheDir", null);
                return false;
            }
            do {
                int n4;
                object2 = this;
                if (((zzbgf)object2).zzeii == null) {
                    n4 = 0;
                } else {
                    n2 = 0;
                    object = ((zzbgf)object2).zzeii.listFiles();
                    int n5 = ((File[])object).length;
                    for (n = 0; n < n5; ++n) {
                        if (object[n].getName().endsWith(".done")) continue;
                        ++n2;
                    }
                    n4 = n2;
                }
                object2 = zzact.zzclv;
                if (n4 <= (Integer)zzyr.zzpe().zzd((zzaci)object2)) break block41;
                object2 = this;
                if (((zzbgf)object2).zzeii == null) {
                    n3 = 0;
                    continue;
                }
                File file = null;
                long l = Long.MAX_VALUE;
                for (File file2 : ((zzbgf)object2).zzeii.listFiles()) {
                    long l2;
                    if (file2.getName().endsWith(".done") || (l2 = file2.lastModified()) >= l) continue;
                    file = file2;
                    l = l2;
                }
                n = 0;
                if (file != null) {
                    n = file.delete() ? 1 : 0;
                    File file3 = ((zzbgf)object2).zzc(file);
                    if (file3.isFile()) {
                        n &= file3.delete();
                    }
                }
                n3 = n;
            } while (n3 != 0);
            zzaxa.zzep((String)"Unable to expire stream cache");
            this.zza(string2, null, "expireFailed", null);
            return false;
        }
        String string3 = this.zzey(string2);
        File file = new File(this.zzeii, string3);
        File file4 = this.zzc(file);
        if (file.isFile() && file4.isFile()) {
            int n6 = (int)file.length();
            String string4 = String.valueOf(string2);
            zzaxa.zzdp((String)(string4.length() != 0 ? "Stream cache hit at ".concat(string4) : new String("Stream cache hit at ")));
            this.zza(string2, file.getAbsolutePath(), n6);
            return true;
        }
        String string5 = String.valueOf(this.zzeii.getAbsolutePath());
        String string6 = String.valueOf(string2);
        String string7 = string6.length() != 0 ? string5.concat(string6) : new String(string5);
        Object object3 = zzeig;
        synchronized (object3) {
            if (zzeig.contains(string7)) {
                String string8 = String.valueOf(string2);
                zzaxa.zzep((String)(string8.length() != 0 ? "Stream cache already in progress at ".concat(string8) : new String("Stream cache already in progress at ")));
                this.zza(string2, file.getAbsolutePath(), "inProgress", null);
                return false;
            }
            zzeig.add(string7);
        }
        object3 = null;
        String string9 = "error";
        String string10 = null;
        try {
            int n7;
            int n8;
            HttpURLConnection httpURLConnection;
            block42: {
                zzk.zzls();
                object2 = zzact.zzcma;
                n2 = (Integer)zzyr.zzpe().zzd((zzaci)object2);
                object2 = string2;
                URL uRL = new URL((String)object2);
                n = 0;
                while (++n <= 20) {
                    File file2;
                    URLConnection uRLConnection = uRL.openConnection();
                    uRLConnection.setConnectTimeout(n2);
                    uRLConnection.setReadTimeout(n2);
                    if (!(uRLConnection instanceof HttpURLConnection)) {
                        throw new IOException("Invalid protocol.");
                    }
                    httpURLConnection = (HttpURLConnection)uRLConnection;
                    file2 = new zzazy();
                    file2.zza(httpURLConnection, null);
                    httpURLConnection.setInstanceFollowRedirects(false);
                    int n9 = httpURLConnection.getResponseCode();
                    file2.zza(httpURLConnection, n9);
                    if (n9 / 100 == 3) {
                        String string11 = httpURLConnection.getHeaderField("Location");
                        if (string11 == null) {
                            throw new IOException("Missing Location header in redirect");
                        }
                        String string12 = (uRL = new URL(uRL, string11)).getProtocol();
                        if (string12 == null) {
                            throw new IOException("Protocol is null");
                        }
                        if (!string12.equals("http") && !string12.equals("https")) {
                            String string13 = String.valueOf(string12);
                            throw new IOException(string13.length() != 0 ? "Unsupported scheme: ".concat(string13) : new String("Unsupported scheme: "));
                        }
                        String string14 = String.valueOf(string11);
                        zzaxa.zzdp((String)(string14.length() != 0 ? "Redirecting to ".concat(string14) : new String("Redirecting to ")));
                        httpURLConnection.disconnect();
                        continue;
                    }
                    break block42;
                }
                throw new IOException("Too many redirects (20)");
            }
            HttpURLConnection httpURLConnection2 = httpURLConnection;
            if (httpURLConnection2 instanceof HttpURLConnection && (n8 = httpURLConnection2.getResponseCode()) >= 400) {
                string9 = "badUrl";
                String string15 = String.valueOf(Integer.toString(n8));
                string10 = string15.length() != 0 ? "HTTP request failed. Code: ".concat(string15) : new String("HTTP request failed. Code: ");
                throw new IOException(new StringBuilder(32 + String.valueOf(string2).length()).append("HTTP status code ").append(n8).append(" at ").append(string2).toString());
            }
            n8 = httpURLConnection2.getContentLength();
            if (n8 < 0) {
                String string16 = String.valueOf(string2);
                zzaxa.zzep((String)(string16.length() != 0 ? "Stream cache aborted, missing content-length header at ".concat(string16) : new String("Stream cache aborted, missing content-length header at ")));
                this.zza(string2, file.getAbsolutePath(), "contentLengthMissing", null);
                zzeig.remove(string7);
                return false;
            }
            String string17 = zzeih.format(n8);
            object2 = zzact.zzclw;
            int n10 = (Integer)zzyr.zzpe().zzd((zzaci)object2);
            if (n8 > n10) {
                zzaxa.zzep((String)new StringBuilder(33 + String.valueOf(string17).length() + String.valueOf(string2).length()).append("Content length ").append(string17).append(" exceeds limit at ").append(string2).toString());
                String string18 = String.valueOf(string17);
                String string19 = string18.length() != 0 ? "File too big for full file cache. Size: ".concat(string18) : new String("File too big for full file cache. Size: ");
                this.zza(string2, file.getAbsolutePath(), "sizeExceeded", string19);
                zzeig.remove(string7);
                return false;
            }
            zzaxa.zzdp((String)new StringBuilder(20 + String.valueOf(string17).length() + String.valueOf(string2).length()).append("Caching ").append(string17).append(" bytes from ").append(string2).toString());
            ReadableByteChannel readableByteChannel = Channels.newChannel(httpURLConnection2.getInputStream());
            object3 = new FileOutputStream(file);
            FileChannel fileChannel = ((FileOutputStream)object3).getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocate(0x100000);
            Clock clock = zzk.zzln();
            int n11 = 0;
            long l = clock.currentTimeMillis();
            object2 = zzact.zzclz;
            long l3 = (Long)zzyr.zzpe().zzd((zzaci)object2);
            zzazk zzazk2 = new zzazk(l3);
            object2 = zzact.zzcly;
            long l4 = (Long)zzyr.zzpe().zzd((zzaci)object2);
            while ((n7 = readableByteChannel.read(byteBuffer)) >= 0) {
                if ((n11 += n7) > n10) {
                    string9 = "sizeExceeded";
                    String string20 = String.valueOf(Integer.toString(n11));
                    string10 = string20.length() != 0 ? "File too big for full file cache. Size: ".concat(string20) : new String("File too big for full file cache. Size: ");
                    throw new IOException("stream cache file size limit exceeded");
                }
                byteBuffer.flip();
                while (fileChannel.write(byteBuffer) > 0) {
                }
                byteBuffer.clear();
                if (clock.currentTimeMillis() - l > l4 * 1000L) {
                    string9 = "downloadTimeout";
                    String string21 = Long.toString(l4);
                    string10 = new StringBuilder(29 + String.valueOf(string21).length()).append("Timeout exceeded. Limit: ").append(string21).append(" sec").toString();
                    throw new IOException("stream cache time limit exceeded");
                }
                if (this.zzeij) {
                    string9 = "externalAbort";
                    throw new IOException("abort requested");
                }
                if (!zzazk2.tryAcquire()) continue;
                n = n8;
                int n12 = n11;
                object = file.getAbsolutePath();
                String string22 = string2;
                object2 = this;
                zzazu.zzyr.post((Runnable)new zzbfv((zzbfu)object2, string22, (String)object, n12, n, false));
            }
            ((FileOutputStream)object3).close();
            if (zzaxa.isLoggable((int)3)) {
                String string23 = zzeih.format(n11);
                zzaxa.zzdp((String)new StringBuilder(22 + String.valueOf(string23).length() + String.valueOf(string2).length()).append("Preloaded ").append(string23).append(" bytes from ").append(string2).toString());
            }
            file.setReadable(true, false);
            object2 = file4;
            if (((File)object2).isFile()) {
                ((File)object2).setLastModified(System.currentTimeMillis());
            } else {
                try {
                    ((File)object2).createNewFile();
                }
                catch (IOException iOException) {}
            }
            this.zza(string2, file.getAbsolutePath(), n11);
            zzeig.remove(string7);
            return true;
        }
        catch (IOException | RuntimeException exception) {
            Exception exception2 = exception;
            if (exception instanceof RuntimeException) {
                zzk.zzlk().zza(exception2, "VideoStreamFullFileCache.preload");
            }
            try {
                ((FileOutputStream)object3).close();
            }
            catch (IOException | NullPointerException exception3) {}
            if (this.zzeij) {
                zzaxa.zzeo((String)new StringBuilder(26 + String.valueOf(string2).length()).append("Preload aborted for URL \"").append(string2).append("\"").toString());
            } else {
                zzaxa.zzd((String)new StringBuilder(25 + String.valueOf(string2).length()).append("Preload failed for URL \"").append(string2).append("\"").toString(), (Throwable)exception2);
            }
            if (file.exists() && !file.delete()) {
                String string24 = String.valueOf(file.getAbsolutePath());
                zzaxa.zzep((String)(string24.length() != 0 ? "Could not delete partial cache file at ".concat(string24) : new String("Could not delete partial cache file at ")));
            }
            this.zza(string2, file.getAbsolutePath(), string9, string10);
            zzeig.remove(string7);
            return false;
        }
    }

    @Override
    public final void abort() {
        this.zzeij = true;
    }

    private final File zzc(File file) {
        return new File(this.zzeii, String.valueOf(file.getName()).concat(".done"));
    }
}

