/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import android.view.TextureView;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.internal.ads.zzare;
import com.google.android.gms.internal.ads.zzaxa;
import com.google.android.gms.internal.ads.zzaxj;
import com.google.android.gms.internal.ads.zzbbn;
import com.google.android.gms.internal.ads.zzbco;
import com.google.android.gms.internal.ads.zzbcp;
import com.google.android.gms.internal.ads.zzbde;
import com.google.android.gms.internal.ads.zzbdf;
import com.google.android.gms.internal.ads.zzbdg;
import com.google.android.gms.internal.ads.zzbdh;
import com.google.android.gms.internal.ads.zzbem;
import com.google.android.gms.internal.ads.zzben;
import com.google.android.gms.internal.ads.zzbeo;
import com.google.android.gms.internal.ads.zzbep;
import com.google.android.gms.internal.ads.zzbeq;
import com.google.android.gms.internal.ads.zzber;
import com.google.android.gms.internal.ads.zzbes;
import com.google.android.gms.internal.ads.zzbet;
import com.google.android.gms.internal.ads.zzbeu;
import com.google.android.gms.internal.ads.zzbev;
import com.google.android.gms.internal.ads.zzbfb;
import com.google.android.gms.internal.ads.zzbfj;
import com.google.android.gms.internal.ads.zzbfu;
import com.google.android.gms.internal.ads.zzbgp;
import com.google.android.gms.internal.ads.zzbgq;
import com.google.android.gms.internal.ads.zzkv;
import java.nio.ByteBuffer;
import java.util.Arrays;

@zzare
@TargetApi(value=16)
public final class zzbel
extends zzbcp
implements TextureView.SurfaceTextureListener,
zzbfj {
    private final zzbdg zzebv;
    private final zzbdh zzeay;
    private final boolean zzeaz;
    private final zzbdf zzefr;
    private zzbco zzebm;
    private Surface zzaez;
    private zzbfb zzegl;
    private String zzeft;
    private String[] zzeci;
    private boolean zzefu;
    private int zzefv = 1;
    private zzbde zzebj;
    private final boolean zzebk;
    private boolean zzefw;
    private boolean zzefx;
    private int zzebe;
    private int zzebf;
    private int zzebh;
    private int zzebi;
    private float zzefp;

    public zzbel(Context context, zzbdh zzbdh2, zzbdg zzbdg2, boolean bl, boolean bl2, zzbdf zzbdf2) {
        super(context);
        this.zzeaz = bl2;
        this.zzebv = zzbdg2;
        this.zzeay = zzbdh2;
        this.zzebk = bl;
        this.zzefr = zzbdf2;
        this.setSurfaceTextureListener(this);
        this.zzeay.zzb(this);
    }

    private final zzbfb zzzh() {
        return new zzbfb(this.zzebv.getContext(), this.zzefr);
    }

    private final String zzzi() {
        return zzk.zzlg().zzq(this.zzebv.getContext(), this.zzebv.zzyh().zzbsy);
    }

    private final boolean zzyv() {
        return this.zzegl != null && !this.zzefu;
    }

    private final boolean zzyw() {
        return this.zzyv() && this.zzefv != 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzzj() {
        block9: {
            block10: {
                if (this.zzegl != null) {
                    return;
                }
                if (this.zzeft == null || this.zzaez == null) {
                    return;
                }
                if (!this.zzeft.startsWith("cache:")) break block10;
                zzbfu zzbfu2 = this.zzebv.zzet(this.zzeft);
                if (zzbfu2 instanceof zzbgq) {
                    zzbgq zzbgq2 = (zzbgq)zzbfu2;
                    this.zzegl = zzbgq2.zzaaa();
                    break block9;
                } else if (zzbfu2 instanceof zzbgp) {
                    zzbgp zzbgp2 = (zzbgp)zzbfu2;
                    String string2 = this.zzzi();
                    ByteBuffer byteBuffer = zzbgp2.getByteBuffer();
                    boolean bl = zzbgp2.zzzv();
                    String string3 = zzbgp2.getUrl();
                    if (string3 == null) {
                        zzaxa.zzep((String)"Stream cache URL is null.");
                        return;
                    }
                    this.zzegl = this.zzzh();
                    this.zzegl.zza(new Uri[]{Uri.parse((String)string3)}, string2, byteBuffer, bl);
                    break block9;
                } else {
                    String string4 = String.valueOf(this.zzeft);
                    zzaxa.zzep((String)(string4.length() != 0 ? "Stream cache miss: ".concat(string4) : new String("Stream cache miss: ")));
                    return;
                }
            }
            this.zzegl = this.zzzh();
            String string5 = this.zzzi();
            Uri[] uriArray = new Uri[this.zzeci.length];
            for (int i = 0; i < this.zzeci.length; ++i) {
                uriArray[i] = Uri.parse((String)this.zzeci[i]);
            }
            this.zzegl.zza(uriArray, string5);
        }
        this.zzegl.zza(this);
        this.zza(this.zzaez, false);
        this.zzefv = this.zzegl.zzzt().getPlaybackState();
        if (this.zzefv == 3) {
            this.zzyy();
        }
    }

    private final void zza(Surface surface, boolean bl) {
        if (this.zzegl != null) {
            this.zzegl.zza(surface, bl);
            return;
        }
        zzaxa.zzep((String)"Trying to set surface before player is initalized.");
    }

    private final void zza(float f, boolean bl) {
        if (this.zzegl != null) {
            this.zzegl.zzb(f, bl);
            return;
        }
        zzaxa.zzep((String)"Trying to set volume before player is initalized.");
    }

    @Override
    public final void zzxk() {
        this.zza(this.zzebu.getVolume(), false);
    }

    private final void zzyy() {
        if (this.zzefw) {
            return;
        }
        this.zzefw = true;
        zzaxj.zzdvx.post((Runnable)new zzbem(this));
        ((zzbcp)this).zzxk();
        this.zzeay.zzhd();
        if (this.zzefx) {
            ((zzbcp)this).play();
        }
    }

    @Override
    public final String zzxg() {
        String string2 = String.valueOf("ExoPlayer/3");
        String string3 = String.valueOf(this.zzebk ? " spherical" : "");
        if (string3.length() != 0) {
            return string2.concat(string3);
        }
        return new String(string2);
    }

    @Override
    public final void zza(zzbco zzbco2) {
        this.zzebm = zzbco2;
    }

    @Override
    public final void setVideoPath(String string2) {
        if (string2 != null) {
            this.zzeft = string2;
            this.zzeci = new String[]{string2};
            this.zzzj();
        }
    }

    @Override
    public final void zzb(String string2, String[] stringArray) {
        if (string2 != null) {
            if (stringArray == null) {
                ((zzbcp)this).setVideoPath(string2);
            }
            this.zzeft = string2;
            this.zzeci = Arrays.copyOf(stringArray, stringArray.length);
            this.zzzj();
        }
    }

    @Override
    public final void play() {
        if (this.zzyw()) {
            if (this.zzefr.zzeee) {
                this.zzzl();
            }
            this.zzegl.zzzt().zzd(true);
            this.zzeay.zzyl();
            this.zzebu.zzyl();
            this.zzebt.zzxm();
            zzaxj.zzdvx.post((Runnable)new zzbep(this));
            return;
        }
        this.zzefx = true;
    }

    @Override
    public final void stop() {
        if (this.zzyv()) {
            this.zzegl.zzzt().stop();
            zzbel zzbel2 = this;
            if (zzbel2.zzegl != null) {
                zzbel2.zza(null, true);
                if (zzbel2.zzegl != null) {
                    zzbel2.zzegl.zza((zzbfj)null);
                    zzbel2.zzegl.release();
                    zzbel2.zzegl = null;
                }
                zzbel2.zzefv = 1;
                zzbel2.zzefu = false;
                zzbel2.zzefw = false;
                zzbel2.zzefx = false;
            }
        }
        this.zzeay.zzym();
        this.zzebu.zzym();
        this.zzeay.onStop();
    }

    @Override
    public final void pause() {
        if (this.zzyw()) {
            if (this.zzefr.zzeee) {
                this.zzzm();
            }
            this.zzegl.zzzt().zzd(false);
            this.zzeay.zzym();
            this.zzebu.zzym();
            zzaxj.zzdvx.post((Runnable)new zzbeq(this));
        }
    }

    @Override
    public final void seekTo(int n) {
        if (this.zzyw()) {
            this.zzegl.zzzt().seekTo(n);
        }
    }

    @Override
    public final void zzcy(int n) {
        if (this.zzegl != null) {
            this.zzegl.zzzu().zzdg(n);
        }
    }

    @Override
    public final void zzcz(int n) {
        if (this.zzegl != null) {
            this.zzegl.zzzu().zzdh(n);
        }
    }

    @Override
    public final void zzda(int n) {
        if (this.zzegl != null) {
            this.zzegl.zzzu().zzda(n);
        }
    }

    @Override
    public final void zzdb(int n) {
        if (this.zzegl != null) {
            this.zzegl.zzzu().zzdb(n);
        }
    }

    @Override
    public final void zzdc(int n) {
        if (this.zzegl != null) {
            this.zzegl.zzdc(n);
        }
    }

    @Override
    public final void zza(float f, float f2) {
        if (this.zzebj != null) {
            this.zzebj.zzb(f, f2);
        }
    }

    @Override
    public final int getCurrentPosition() {
        if (this.zzyw()) {
            return (int)this.zzegl.zzzt().zzdn();
        }
        return 0;
    }

    @Override
    public final int getDuration() {
        if (this.zzyw()) {
            return (int)this.zzegl.zzzt().getDuration();
        }
        return 0;
    }

    @Override
    public final int getVideoWidth() {
        return this.zzebe;
    }

    @Override
    public final int getVideoHeight() {
        return this.zzebf;
    }

    protected final void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
        int n3 = this.getMeasuredWidth();
        int n4 = this.getMeasuredHeight();
        if (this.zzefp != 0.0f && this.zzebj == null) {
            float f = (float)n3 / (float)n4;
            if (this.zzefp > f) {
                n4 = (int)((float)n3 / this.zzefp);
            }
            if (this.zzefp < f) {
                n3 = (int)((float)n4 * this.zzefp);
            }
        }
        this.setMeasuredDimension(n3, n4);
        if (this.zzebj != null) {
            this.zzebj.zzm(n3, n4);
        }
        if (Build.VERSION.SDK_INT == 16) {
            if (this.zzebh > 0 && this.zzebh != n3 || this.zzebi > 0 && this.zzebi != n4) {
                zzkv zzkv2;
                zzbel zzbel2 = this;
                if (zzbel2.zzeaz && zzbel2.zzyv() && (zzkv2 = zzbel2.zzegl.zzzt()).zzdn() > 0L && !zzkv2.zzdm()) {
                    zzbel2.zza(0.0f, true);
                    zzkv2.zzd(true);
                    long l = zzkv2.zzdn();
                    long l2 = zzk.zzln().currentTimeMillis();
                    while (zzbel2.zzyv() && zzkv2.zzdn() == l && zzk.zzln().currentTimeMillis() - l2 <= 250L) {
                    }
                    zzkv2.zzd(false);
                    ((zzbcp)zzbel2).zzxk();
                }
            }
            this.zzebh = n3;
            this.zzebi = n4;
        }
    }

    public final void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
        if (this.zzebk) {
            this.zzebj = new zzbde(this.getContext());
            this.zzebj.zza(surfaceTexture, n, n2);
            this.zzebj.start();
            SurfaceTexture surfaceTexture2 = this.zzebj.zzxy();
            if (surfaceTexture2 != null) {
                surfaceTexture = surfaceTexture2;
            } else {
                this.zzebj.zzxx();
                this.zzebj = null;
            }
        }
        SurfaceTexture surfaceTexture3 = surfaceTexture;
        this.zzaez = new Surface(surfaceTexture3);
        if (this.zzegl == null) {
            this.zzzj();
        } else {
            this.zza(this.zzaez, true);
            if (!this.zzefr.zzeee) {
                this.zzzl();
            }
        }
        if (this.zzebe == 0 || this.zzebf == 0) {
            this.zzp(n, n2);
        } else {
            this.zzzk();
        }
        zzaxj.zzdvx.post((Runnable)new zzber(this));
    }

    public final void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
        if (this.zzebj != null) {
            this.zzebj.zzm(n, n2);
        }
        zzaxj.zzdvx.post((Runnable)new zzbes(this, n, n2));
    }

    public final void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        this.zzeay.zzc(this);
        this.zzebt.zza(surfaceTexture, this.zzebm);
    }

    public final boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        ((zzbcp)this).pause();
        if (this.zzebj != null) {
            this.zzebj.zzxx();
            this.zzebj = null;
        }
        if (this.zzegl != null) {
            this.zzzm();
            if (this.zzaez != null) {
                this.zzaez.release();
            }
            this.zzaez = null;
            this.zza(null, true);
        }
        zzaxj.zzdvx.post((Runnable)new zzbet(this));
        return true;
    }

    protected final void onWindowVisibilityChanged(int n) {
        zzaxa.zzds(new StringBuilder(57).append("AdExoPlayerView3 window visibility changed to ").append(n).toString());
        zzaxj.zzdvx.post((Runnable)new zzbeu(this, n));
        super.onWindowVisibilityChanged(n);
    }

    @Override
    public final void zzd(boolean bl, long l) {
        if (this.zzebv != null) {
            zzbbn.zzeag.execute(new zzbev(this, bl, l));
        }
    }

    @Override
    public final void zzde(int n) {
        if (this.zzefv != n) {
            this.zzefv = n;
            switch (n) {
                case 3: {
                    this.zzyy();
                    return;
                }
                case 4: {
                    zzbel zzbel2 = this;
                    if (zzbel2.zzefr.zzeee) {
                        zzbel2.zzzm();
                    }
                    zzbel2.zzeay.zzym();
                    zzbel2.zzebu.zzym();
                    zzaxj.zzdvx.post((Runnable)new zzben(zzbel2));
                }
            }
        }
    }

    @Override
    public final void zzo(int n, int n2) {
        this.zzebe = n;
        this.zzebf = n2;
        this.zzzk();
    }

    @Override
    public final void zza(String string2, Exception exception) {
        Exception exception2 = exception;
        String string3 = string2;
        zzbel zzbel2 = this;
        String string4 = exception2.getClass().getCanonicalName();
        String string5 = exception2.getMessage();
        String string6 = new StringBuilder(2 + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length()).append(string3).append("/").append(string4).append(":").append(string5).toString();
        String string7 = String.valueOf(string6);
        zzaxa.zzep((String)(string7.length() != 0 ? "ExoPlayerAdapter error: ".concat(string7) : new String("ExoPlayerAdapter error: ")));
        zzbel2.zzefu = true;
        if (zzbel2.zzefr.zzeee) {
            zzbel2.zzzm();
        }
        zzaxj.zzdvx.post((Runnable)new zzbeo(zzbel2, string6));
    }

    private final void zzzk() {
        this.zzp(this.zzebe, this.zzebf);
    }

    private final void zzp(int n, int n2) {
        float f;
        float f2 = f = n2 > 0 ? (float)n / (float)n2 : 1.0f;
        if (this.zzefp != f) {
            this.zzefp = f;
            this.requestLayout();
        }
    }

    private final void zzzl() {
        if (this.zzegl != null) {
            this.zzegl.zzap(true);
        }
    }

    private final void zzzm() {
        if (this.zzegl != null) {
            this.zzegl.zzap(false);
        }
    }

    final /* synthetic */ void zze(boolean bl, long l) {
        this.zzebv.zza(bl, l);
    }

    final /* synthetic */ void zzdf(int n) {
        if (this.zzebm != null) {
            this.zzebm.onWindowVisibilityChanged(n);
        }
    }

    final /* synthetic */ void zzzn() {
        if (this.zzebm != null) {
            this.zzebm.zzxo();
        }
    }

    final /* synthetic */ void zzq(int n, int n2) {
        if (this.zzebm != null) {
            this.zzebm.zzk(n, n2);
        }
    }

    final /* synthetic */ void zzzo() {
        if (this.zzebm != null) {
            this.zzebm.zzxl();
        }
    }

    final /* synthetic */ void zzzp() {
        if (this.zzebm != null) {
            this.zzebm.onPaused();
        }
    }

    final /* synthetic */ void zzzq() {
        if (this.zzebm != null) {
            this.zzebm.zzxm();
        }
    }

    final /* synthetic */ void zzeu(String string2) {
        if (this.zzebm != null) {
            this.zzebm.zzl("ExoPlayerAdapter error", string2);
        }
    }

    final /* synthetic */ void zzzr() {
        if (this.zzebm != null) {
            this.zzebm.zzxn();
        }
    }

    final /* synthetic */ void zzzs() {
        if (this.zzebm != null) {
            this.zzebm.zzhd();
        }
    }
}

