/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.net.Uri;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.common.util.IOUtils;
import com.google.android.gms.internal.ads.zzaci;
import com.google.android.gms.internal.ads.zzact;
import com.google.android.gms.internal.ads.zzare;
import com.google.android.gms.internal.ads.zzaxa;
import com.google.android.gms.internal.ads.zzbej;
import com.google.android.gms.internal.ads.zzjp;
import com.google.android.gms.internal.ads.zzjq;
import com.google.android.gms.internal.ads.zzvq;
import com.google.android.gms.internal.ads.zzvt;
import com.google.android.gms.internal.ads.zzwg;
import com.google.android.gms.internal.ads.zzyr;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@zzare
public final class zzbei
implements zzjp {
    private InputStream zzege;
    private boolean isOpen;
    private final Context zzlj;
    private final zzjp zzegf;
    private final WeakReference<zzbej> zzegg;

    public zzbei(Context context, zzjp zzjp2, zzbej zzbej2) {
        this.zzlj = context;
        this.zzegf = zzjp2;
        this.zzegg = new WeakReference<zzbej>(zzbej2);
    }

    @Override
    public final void close() throws IOException {
        if (!this.isOpen) {
            throw new IOException("Attempt to close an already closed CacheDataSource.");
        }
        this.isOpen = false;
        if (this.zzege != null) {
            IOUtils.closeQuietly((Closeable)this.zzege);
            this.zzege = null;
            return;
        }
        this.zzegf.close();
    }

    /*
     * Loose catch block
     */
    @Override
    public final long zza(zzjq zzjq2) throws IOException {
        if (this.isOpen) {
            throw new IOException("Attempt to open an already open CacheDataSource.");
        }
        this.isOpen = true;
        zzvt zzvt2 = zzvt.zze(zzjq2.uri);
        zzaci zzaci2 = zzact.zzctt;
        if (((Boolean)zzyr.zzpe().zzd(zzaci2)).booleanValue()) {
            if (zzvt2 != null) {
                long l;
                Long l2;
                zzvt2.zzbwz = zzjq2.zzahv;
                if (zzvt2.zzbwy) {
                    zzaci2 = zzact.zzctv;
                    l2 = (Long)zzyr.zzpe().zzd(zzaci2);
                } else {
                    zzaci2 = zzact.zzctu;
                    l2 = (Long)zzyr.zzpe().zzd(zzaci2);
                }
                long l3 = l2;
                long l4 = zzk.zzln().elapsedRealtime();
                zzk.zzma();
                Future<InputStream> future = zzwg.zza(this.zzlj, zzvt2);
                try {
                    this.zzege = future.get(l3, TimeUnit.MILLISECONDS);
                    l = zzk.zzln().elapsedRealtime() - l4;
                }
                catch (ExecutionException | TimeoutException exception) {
                    future.cancel(true);
                }
                catch (InterruptedException interruptedException) {
                    future.cancel(true);
                    Thread.currentThread().interrupt();
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    long l5 = zzk.zzln().elapsedRealtime() - l4;
                    zzbej zzbej2 = (zzbej)this.zzegg.get();
                    if (zzbej2 != null) {
                        zzbej2.zzd(false, l5);
                    }
                    zzaxa.zzds(new StringBuilder(44).append("Cache connection took ").append(l5).append("ms").toString());
                }
                zzbej zzbej3 = (zzbej)this.zzegg.get();
                if (zzbej3 != null) {
                    zzbej3.zzd(true, l);
                }
                zzaxa.zzds(new StringBuilder(44).append("Cache connection took ").append(l).append("ms").toString());
                return -1L;
            }
        } else {
            zzvq zzvq2 = null;
            if (zzvt2 != null) {
                zzvt2.zzbwz = zzjq2.zzahv;
                zzvq2 = zzk.zzlm().zza(zzvt2);
            }
            if (zzvq2 != null && zzvq2.zznh()) {
                this.zzege = zzvq2.zzni();
                return -1L;
            }
        }
        if (zzvt2 != null) {
            zzjq2 = new zzjq(Uri.parse((String)zzvt2.url), zzjq2.zzapg, zzjq2.zzahv, zzjq2.zzcd, zzjq2.zzcc, zzjq2.flags);
        }
        return this.zzegf.zza(zzjq2);
    }

    @Override
    public final int read(byte[] byArray, int n, int n2) throws IOException {
        if (!this.isOpen) {
            throw new IOException("Attempt to read closed CacheDataSource.");
        }
        if (this.zzege != null) {
            return this.zzege.read(byArray, n, n2);
        }
        return this.zzegf.read(byArray, n, n2);
    }
}

