/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.util.Log;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzaci;
import com.google.android.gms.internal.ads.zzact;
import com.google.android.gms.internal.ads.zzare;
import com.google.android.gms.internal.ads.zzaxa;
import com.google.android.gms.internal.ads.zzbdb;
import com.google.android.gms.internal.ads.zzbdd;
import com.google.android.gms.internal.ads.zzyr;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.concurrent.CountDownLatch;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

@zzare
@TargetApi(value=14)
public final class zzbde
extends Thread
implements SurfaceTexture.OnFrameAvailableListener,
zzbdd {
    private static final float[] zzedf = new float[]{-1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f};
    private final zzbdb zzedg;
    private final float[] zzedc;
    private final float[] zzedh;
    private final float[] zzedi;
    private final float[] zzedj;
    private final float[] zzedk;
    private final float[] zzedl;
    private final float[] zzedm;
    private float zzedn;
    private float zzedo;
    private float zzedp;
    private int height;
    private int width;
    private SurfaceTexture zzedq;
    private SurfaceTexture zzedr;
    private int zzeds;
    private int zzedt;
    private int zzedu;
    private FloatBuffer zzedv = ByteBuffer.allocateDirect(zzedf.length << 2).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private final CountDownLatch zzedw;
    private final Object zzedx;
    private EGL10 zzedy;
    private EGLDisplay zzedz;
    private EGLContext zzeea;
    private EGLSurface zzeeb;
    private volatile boolean zzeec;
    private volatile boolean zzeed;

    public zzbde(Context context) {
        super("SphericalVideoProcessor");
        this.zzedv.put(zzedf).position(0);
        this.zzedc = new float[9];
        this.zzedh = new float[9];
        this.zzedi = new float[9];
        this.zzedj = new float[9];
        this.zzedk = new float[9];
        this.zzedl = new float[9];
        this.zzedm = new float[9];
        this.zzedn = Float.NaN;
        this.zzedg = new zzbdb(context);
        this.zzedg.zza(this);
        this.zzedw = new CountDownLatch(1);
        this.zzedx = new Object();
    }

    public final void zza(SurfaceTexture surfaceTexture, int n, int n2) {
        this.width = n;
        this.height = n2;
        this.zzedr = surfaceTexture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzm(int n, int n2) {
        Object object = this.zzedx;
        synchronized (object) {
            this.width = n;
            this.height = n2;
            this.zzeec = true;
            this.zzedx.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzxx() {
        Object object = this.zzedx;
        synchronized (object) {
            this.zzeed = true;
            this.zzedr = null;
            this.zzedx.notifyAll();
            return;
        }
    }

    public final SurfaceTexture zzxy() {
        if (this.zzedr == null) {
            return null;
        }
        try {
            this.zzedw.await();
        }
        catch (InterruptedException interruptedException) {}
        return this.zzedq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onFrameAvailable(SurfaceTexture surfaceTexture) {
        ++this.zzedu;
        Object object = this.zzedx;
        synchronized (object) {
            this.zzedx.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zztk() {
        Object object = this.zzedx;
        synchronized (object) {
            this.zzedx.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        boolean bl;
        int n;
        String string2;
        zzaci zzaci2;
        Object object;
        Object[] objectArray;
        Object object2;
        boolean bl2;
        if (this.zzedr == null) {
            zzaxa.zzen((String)"SphericalVideoProcessor started with no output texture.");
            this.zzedw.countDown();
            return;
        }
        zzbde zzbde2 = this;
        this.zzedy = (EGL10)EGLContext.getEGL();
        zzbde2.zzedz = zzbde2.zzedy.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (zzbde2.zzedz == EGL10.EGL_NO_DISPLAY) {
            bl2 = false;
        } else {
            int[] nArray = new int[2];
            if (!zzbde2.zzedy.eglInitialize(zzbde2.zzedz, nArray)) {
                bl2 = false;
            } else {
                object2 = zzbde2;
                int[] nArray2 = new int[]{12352, 4, 12324, 8, 12323, 8, 12322, 8, 12325, 16, 12344};
                EGLConfig[] eGLConfigArray = new EGLConfig[1];
                objectArray = new int[1];
                object = ((zzbde)object2).zzedy.eglChooseConfig(((zzbde)object2).zzedz, nArray2, eGLConfigArray, 1, objectArray) && objectArray[0] > 0 ? eGLConfigArray[0] : null;
                if ((EGLConfig)object == null) {
                    bl2 = false;
                } else {
                    int[] nArray3 = new int[]{12440, 2, 12344};
                    zzbde2.zzeea = zzbde2.zzedy.eglCreateContext(zzbde2.zzedz, (EGLConfig)object, EGL10.EGL_NO_CONTEXT, nArray3);
                    if (zzbde2.zzeea == null || zzbde2.zzeea == EGL10.EGL_NO_CONTEXT) {
                        bl2 = false;
                    } else {
                        zzbde2.zzeeb = zzbde2.zzedy.eglCreateWindowSurface(zzbde2.zzedz, (EGLConfig)object, (Object)zzbde2.zzedr, null);
                        bl2 = zzbde2.zzeeb == null || zzbde2.zzeeb == EGL10.EGL_NO_SURFACE ? false : zzbde2.zzedy.eglMakeCurrent(zzbde2.zzedz, zzbde2.zzeeb, zzbde2.zzeeb, zzbde2.zzeea);
                    }
                }
            }
        }
        boolean bl3 = bl2;
        zzbde2 = this;
        zzaci zzaci3 = zzaci2 = zzact.zzcqf;
        if (!((String)zzyr.zzpe().zzd(zzaci3)).equals(zzaci2.zzqm())) {
            zzaci3 = zzaci2;
            string2 = (String)zzyr.zzpe().zzd(zzaci3);
        } else {
            string2 = "attribute highp vec3 aPosition;varying vec3 pos;void main() {  gl_Position = vec4(aPosition, 1.0);  pos = aPosition;}";
        }
        int n2 = zzbde.zzd(35633, string2);
        if (n2 == 0) {
            n = 0;
        } else {
            String string3;
            zzaci3 = zzaci2 = zzact.zzcqg;
            if (!((String)zzyr.zzpe().zzd(zzaci3)).equals(zzaci2.zzqm())) {
                zzaci3 = zzaci2;
                string3 = (String)zzyr.zzpe().zzd(zzaci3);
            } else {
                string3 = "#extension GL_OES_EGL_image_external : require\n#define INV_PI 0.3183\nprecision highp float;varying vec3 pos;uniform samplerExternalOES uSplr;uniform mat3 uVMat;uniform float uFOVx;uniform float uFOVy;void main() {  vec3 ray = vec3(pos.x * tan(uFOVx), pos.y * tan(uFOVy), -1);  ray = (uVMat * ray).xyz;  ray = normalize(ray);  vec2 texCrd = vec2(    0.5 + atan(ray.x, - ray.z) * INV_PI * 0.5, acos(ray.y) * INV_PI);  gl_FragColor = vec4(texture2D(uSplr, texCrd).xyz, 1.0);}";
            }
            int n3 = zzbde.zzd(35632, string3);
            if (n3 == 0) {
                n = 0;
            } else {
                int n4 = GLES20.glCreateProgram();
                zzbde.zzes("createProgram");
                if (n4 != 0) {
                    GLES20.glAttachShader((int)n4, (int)n2);
                    zzbde.zzes("attachShader");
                    GLES20.glAttachShader((int)n4, (int)n3);
                    zzbde.zzes("attachShader");
                    GLES20.glLinkProgram((int)n4);
                    zzbde.zzes("linkProgram");
                    int[] nArray = new int[1];
                    GLES20.glGetProgramiv((int)n4, (int)35714, (int[])nArray, (int)0);
                    zzbde.zzes("getProgramiv");
                    if (nArray[0] != 1) {
                        Log.e((String)"SphericalVideoRenderer", (String)"Could not link program: ");
                        Log.e((String)"SphericalVideoRenderer", (String)GLES20.glGetProgramInfoLog((int)n4));
                        GLES20.glDeleteProgram((int)n4);
                        zzbde.zzes("deleteProgram");
                        n4 = 0;
                    } else {
                        GLES20.glValidateProgram((int)n4);
                        zzbde.zzes("validateProgram");
                    }
                }
                n = n4;
            }
        }
        this.zzeds = n;
        GLES20.glUseProgram((int)zzbde2.zzeds);
        zzbde.zzes("useProgram");
        int n5 = GLES20.glGetAttribLocation((int)zzbde2.zzeds, (String)"aPosition");
        GLES20.glVertexAttribPointer((int)n5, (int)3, (int)5126, (boolean)false, (int)12, (Buffer)zzbde2.zzedv);
        zzbde.zzes("vertexAttribPointer");
        GLES20.glEnableVertexAttribArray((int)n5);
        zzbde.zzes("enableVertexAttribArray");
        object = new int[1];
        GLES20.glGenTextures((int)1, (int[])object, (int)0);
        zzbde.zzes("genTextures");
        int n6 = object[0];
        GLES20.glBindTexture((int)36197, (int)n6);
        zzbde.zzes("bindTextures");
        GLES20.glTexParameteri((int)36197, (int)10240, (int)9729);
        zzbde.zzes("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10241, (int)9729);
        zzbde.zzes("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        zzbde.zzes("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        zzbde.zzes("texParameteri");
        zzbde2.zzedt = GLES20.glGetUniformLocation((int)zzbde2.zzeds, (String)"uVMat");
        object2 = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        GLES20.glUniformMatrix3fv((int)zzbde2.zzedt, (int)1, (boolean)false, (float[])object2, (int)0);
        int n7 = n6;
        boolean bl4 = bl = this.zzeds != 0;
        if (!bl3 || !bl) {
            String string4 = GLUtils.getEGLErrorString((int)this.zzedy.eglGetError());
            String string5 = String.valueOf(string4);
            String string6 = string5.length() != 0 ? "EGL initialization failed: ".concat(string5) : new String("EGL initialization failed: ");
            zzaxa.zzen((String)string6);
            zzk.zzlk().zza(new Throwable(string6), "SphericalVideoProcessor.run.1");
            this.zzxz();
            this.zzedw.countDown();
            return;
        }
        this.zzedq = new SurfaceTexture(n7);
        this.zzedq.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        this.zzedw.countDown();
        this.zzedg.start();
        try {
            this.zzeec = true;
            while (!this.zzeed) {
                zzbde2 = this;
                while (zzbde2.zzedu > 0) {
                    zzbde2.zzedq.updateTexImage();
                    --zzbde2.zzedu;
                }
                if (zzbde2.zzedg.zza(zzbde2.zzedc)) {
                    if (Float.isNaN(zzbde2.zzedn)) {
                        float[] fArray = zzbde2.zzedc;
                        objectArray = new float[]{0.0f, 1.0f, 0.0f};
                        object2 = zzbde2.zzedc;
                        float[] fArray2 = new float[]{(float)(object2[0] * objectArray[0] + object2[1] * objectArray[1] + object2[2] * objectArray[2]), (float)(object2[3] * objectArray[0] + object2[4] * objectArray[1] + object2[5] * objectArray[2]), (float)(object2[6] * objectArray[0] + object2[7] * objectArray[1] + object2[8] * objectArray[2])};
                        zzbde2.zzedn = -((float)Math.atan2(fArray2[1], fArray2[0]) - 1.5707964f);
                    }
                    zzbde.zzb(zzbde2.zzedl, zzbde2.zzedn + zzbde2.zzedo);
                } else {
                    zzbde.zza(zzbde2.zzedc, -1.5707964f);
                    zzbde.zzb(zzbde2.zzedl, zzbde2.zzedo);
                }
                zzbde.zza(zzbde2.zzedh, 1.5707964f);
                zzbde.zza(zzbde2.zzedi, zzbde2.zzedl, zzbde2.zzedh);
                zzbde.zza(zzbde2.zzedj, zzbde2.zzedc, zzbde2.zzedi);
                zzbde.zza(zzbde2.zzedk, zzbde2.zzedp);
                zzbde.zza(zzbde2.zzedm, zzbde2.zzedk, zzbde2.zzedj);
                GLES20.glUniformMatrix3fv((int)zzbde2.zzedt, (int)1, (boolean)false, (float[])zzbde2.zzedm, (int)0);
                GLES20.glDrawArrays((int)5, (int)0, (int)4);
                zzbde.zzes("drawArrays");
                GLES20.glFinish();
                zzbde2.zzedy.eglSwapBuffers(zzbde2.zzedz, zzbde2.zzeeb);
                if (this.zzeec) {
                    zzbde2 = this;
                    GLES20.glViewport((int)0, (int)0, (int)zzbde2.width, (int)zzbde2.height);
                    zzbde.zzes("viewport");
                    n5 = GLES20.glGetUniformLocation((int)zzbde2.zzeds, (String)"uFOVx");
                    int n8 = GLES20.glGetUniformLocation((int)zzbde2.zzeds, (String)"uFOVy");
                    if (zzbde2.width > zzbde2.height) {
                        GLES20.glUniform1f((int)n5, (float)0.87266463f);
                        GLES20.glUniform1f((int)n8, (float)(0.87266463f * (float)zzbde2.height / (float)zzbde2.width));
                    } else {
                        GLES20.glUniform1f((int)n5, (float)(0.87266463f * (float)zzbde2.width / (float)zzbde2.height));
                        GLES20.glUniform1f((int)n8, (float)0.87266463f);
                    }
                    this.zzeec = false;
                }
                try {
                    Object object3 = this.zzedx;
                    synchronized (object3) {
                        if (!this.zzeed && !this.zzeec && this.zzedu == 0) {
                            this.zzedx.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
            return;
        }
        catch (IllegalStateException illegalStateException) {
            zzaxa.zzep((String)"SphericalVideoProcessor halted unexpectedly.");
            return;
        }
        catch (Throwable throwable) {
            zzaxa.zzc((String)"SphericalVideoProcessor died.", (Throwable)throwable);
            zzk.zzlk().zza(throwable, "SphericalVideoProcessor.run.2");
            return;
        }
        finally {
            this.zzedg.stop();
            this.zzedq.setOnFrameAvailableListener(null);
            this.zzedq = null;
            this.zzxz();
        }
    }

    public final void zzb(float f, float f2) {
        float f3;
        float f4;
        if (this.width > this.height) {
            f4 = 1.7453293f * f / (float)this.width;
            f3 = 1.7453293f * f2 / (float)this.width;
        } else {
            f4 = 1.7453293f * f / (float)this.height;
            f3 = 1.7453293f * f2 / (float)this.height;
        }
        this.zzedo -= f4;
        this.zzedp -= f3;
        if (this.zzedp < -1.5707964f) {
            this.zzedp = -1.5707964f;
        }
        if (this.zzedp > 1.5707964f) {
            this.zzedp = 1.5707964f;
        }
    }

    private static void zza(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray[0] = fArray2[0] * fArray3[0] + fArray2[1] * fArray3[3] + fArray2[2] * fArray3[6];
        fArray[1] = fArray2[0] * fArray3[1] + fArray2[1] * fArray3[4] + fArray2[2] * fArray3[7];
        fArray[2] = fArray2[0] * fArray3[2] + fArray2[1] * fArray3[5] + fArray2[2] * fArray3[8];
        fArray[3] = fArray2[3] * fArray3[0] + fArray2[4] * fArray3[3] + fArray2[5] * fArray3[6];
        fArray[4] = fArray2[3] * fArray3[1] + fArray2[4] * fArray3[4] + fArray2[5] * fArray3[7];
        fArray[5] = fArray2[3] * fArray3[2] + fArray2[4] * fArray3[5] + fArray2[5] * fArray3[8];
        fArray[6] = fArray2[6] * fArray3[0] + fArray2[7] * fArray3[3] + fArray2[8] * fArray3[6];
        fArray[7] = fArray2[6] * fArray3[1] + fArray2[7] * fArray3[4] + fArray2[8] * fArray3[7];
        fArray[8] = fArray2[6] * fArray3[2] + fArray2[7] * fArray3[5] + fArray2[8] * fArray3[8];
    }

    private static void zza(float[] fArray, float f) {
        fArray[0] = 1.0f;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = (float)Math.cos(f);
        fArray[5] = (float)(-Math.sin(f));
        fArray[6] = 0.0f;
        fArray[7] = (float)Math.sin(f);
        fArray[8] = (float)Math.cos(f);
    }

    private static void zzb(float[] fArray, float f) {
        fArray[0] = (float)Math.cos(f);
        fArray[1] = (float)(-Math.sin(f));
        fArray[2] = 0.0f;
        fArray[3] = (float)Math.sin(f);
        fArray[4] = (float)Math.cos(f);
        fArray[5] = 0.0f;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 1.0f;
    }

    private static int zzd(int n, String string2) {
        int n2 = GLES20.glCreateShader((int)n);
        zzbde.zzes("createShader");
        if (n2 != 0) {
            GLES20.glShaderSource((int)n2, (String)string2);
            zzbde.zzes("shaderSource");
            GLES20.glCompileShader((int)n2);
            zzbde.zzes("compileShader");
            int[] nArray = new int[1];
            GLES20.glGetShaderiv((int)n2, (int)35713, (int[])nArray, (int)0);
            zzbde.zzes("getShaderiv");
            if (nArray[0] == 0) {
                Log.e((String)"SphericalVideoRenderer", (String)new StringBuilder(37).append("Could not compile shader ").append(n).append(":").toString());
                Log.e((String)"SphericalVideoRenderer", (String)GLES20.glGetShaderInfoLog((int)n2));
                GLES20.glDeleteShader((int)n2);
                zzbde.zzes("deleteShader");
                n2 = 0;
            }
        }
        return n2;
    }

    @VisibleForTesting
    private final boolean zzxz() {
        boolean bl = false;
        if (this.zzeeb != null && this.zzeeb != EGL10.EGL_NO_SURFACE) {
            bl = false | this.zzedy.eglMakeCurrent(this.zzedz, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT) | this.zzedy.eglDestroySurface(this.zzedz, this.zzeeb);
            this.zzeeb = null;
        }
        if (this.zzeea != null) {
            bl |= this.zzedy.eglDestroyContext(this.zzedz, this.zzeea);
            this.zzeea = null;
        }
        if (this.zzedz != null) {
            bl |= this.zzedy.eglTerminate(this.zzedz);
            this.zzedz = null;
        }
        return bl;
    }

    private static void zzes(String string2) {
        int n = GLES20.glGetError();
        if (n != 0) {
            Log.e((String)"SphericalVideoRenderer", (String)new StringBuilder(21 + String.valueOf(string2).length()).append(string2).append(": glError ").append(n).toString());
        }
    }
}

