/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.view.Display;
import android.view.WindowManager;
import com.google.android.gms.internal.ads.zzare;
import com.google.android.gms.internal.ads.zzaxa;
import com.google.android.gms.internal.ads.zzbdc;
import com.google.android.gms.internal.ads.zzbdd;
import com.google.android.gms.internal.ads.zzdbg;
import javax.annotation.concurrent.GuardedBy;

@zzare
final class zzbdb
implements SensorEventListener {
    private final SensorManager zzecx;
    private final Object zzecy;
    private final Display zzecz;
    private final float[] zzeda;
    private final float[] zzedb;
    @GuardedBy(value="sensorThreadLock")
    private float[] zzedc;
    private Handler zzedd;
    private zzbdd zzede;

    zzbdb(Context context) {
        this.zzecx = (SensorManager)context.getSystemService("sensor");
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        this.zzecz = windowManager.getDefaultDisplay();
        this.zzeda = new float[9];
        this.zzedb = new float[9];
        this.zzecy = new Object();
    }

    final void start() {
        if (this.zzedd != null) {
            return;
        }
        Sensor sensor = this.zzecx.getDefaultSensor(11);
        if (sensor == null) {
            zzaxa.zzen((String)"No Sensor of TYPE_ROTATION_VECTOR");
            return;
        }
        HandlerThread handlerThread = new HandlerThread("OrientationMonitor");
        handlerThread.start();
        this.zzedd = new zzdbg(handlerThread.getLooper());
        if (!this.zzecx.registerListener((SensorEventListener)this, sensor, 0, this.zzedd)) {
            zzaxa.zzen((String)"SensorManager.registerListener failed.");
            this.stop();
        }
    }

    final void stop() {
        if (this.zzedd == null) {
            return;
        }
        this.zzecx.unregisterListener((SensorEventListener)this);
        this.zzedd.post((Runnable)new zzbdc(this));
        this.zzedd = null;
    }

    final void zza(zzbdd zzbdd2) {
        this.zzede = zzbdd2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onSensorChanged(SensorEvent sensorEvent) {
        float[] fArray = sensorEvent.values;
        zzbdb zzbdb2 = this;
        if (fArray[0] != 0.0f || fArray[1] != 0.0f || fArray[2] != 0.0f) {
            Object object = zzbdb2.zzecy;
            synchronized (object) {
                if (zzbdb2.zzedc == null) {
                    zzbdb2.zzedc = new float[9];
                }
            }
            SensorManager.getRotationMatrixFromVector((float[])zzbdb2.zzeda, (float[])fArray);
            switch (zzbdb2.zzecz.getRotation()) {
                case 1: {
                    SensorManager.remapCoordinateSystem((float[])zzbdb2.zzeda, (int)2, (int)129, (float[])zzbdb2.zzedb);
                    break;
                }
                case 2: {
                    SensorManager.remapCoordinateSystem((float[])zzbdb2.zzeda, (int)129, (int)130, (float[])zzbdb2.zzedb);
                    break;
                }
                case 3: {
                    SensorManager.remapCoordinateSystem((float[])zzbdb2.zzeda, (int)130, (int)1, (float[])zzbdb2.zzedb);
                    break;
                }
                default: {
                    System.arraycopy(zzbdb2.zzeda, 0, zzbdb2.zzedb, 0, 9);
                }
            }
            zzbdb2.zzl(1, 3);
            zzbdb2.zzl(2, 6);
            zzbdb2.zzl(5, 7);
            Object object2 = zzbdb2.zzecy;
            synchronized (object2) {
                System.arraycopy(zzbdb2.zzedb, 0, zzbdb2.zzedc, 0, 9);
            }
            if (zzbdb2.zzede != null) {
                zzbdb2.zzede.zztk();
            }
        }
    }

    public final void onAccuracyChanged(Sensor sensor, int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean zza(float[] fArray) {
        Object object = this.zzecy;
        synchronized (object) {
            if (this.zzedc == null) {
                return false;
            }
            System.arraycopy(this.zzedc, 0, fArray, 0, this.zzedc.length);
            return true;
        }
    }

    private final void zzl(int n, int n2) {
        float f = this.zzedb[n];
        this.zzedb[n] = this.zzedb[n2];
        this.zzedb[n2] = f;
    }
}

