/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.content.Context;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.zze;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzaci;
import com.google.android.gms.internal.ads.zzact;
import com.google.android.gms.internal.ads.zzalk;
import com.google.android.gms.internal.ads.zzalp;
import com.google.android.gms.internal.ads.zzare;
import com.google.android.gms.internal.ads.zzawm;
import com.google.android.gms.internal.ads.zzaxa;
import com.google.android.gms.internal.ads.zzbaj;
import com.google.android.gms.internal.ads.zzbap;
import com.google.android.gms.internal.ads.zzbas;
import com.google.android.gms.internal.ads.zzbbi;
import com.google.android.gms.internal.ads.zzbbn;
import com.google.android.gms.internal.ads.zzyr;
import javax.annotation.ParametersAreNonnullByDefault;
import org.json.JSONObject;

@zzare
@ParametersAreNonnullByDefault
public final class zzd {
    private Context zzlj;
    private long zzbqz = 0L;

    public final void zza(Context context, zzbaj zzbaj2, String string2, @Nullable Runnable runnable) {
        this.zza(context, zzbaj2, true, null, string2, null, runnable);
    }

    public final void zza(Context context, zzbaj zzbaj2, String string2, zzawm zzawm2) {
        String string3 = zzawm2 != null ? zzawm2.zzut() : null;
        this.zza(context, zzbaj2, false, zzawm2, string3, string2, null);
    }

    @VisibleForTesting
    private final void zza(Context context, zzbaj zzbaj2, boolean bl, @Nullable zzawm zzawm2, String string2, @Nullable String string3, @Nullable Runnable runnable) {
        boolean bl2;
        if (zzk.zzln().elapsedRealtime() - this.zzbqz < 5000L) {
            zzaxa.zzep((String)"Not retrying to fetch app settings");
            return;
        }
        this.zzbqz = zzk.zzln().elapsedRealtime();
        zzawm zzawm3 = zzawm2;
        if (zzawm3 == null) {
            bl2 = true;
        } else {
            long l = zzawm3.zzuq();
            zzaci zzaci2 = zzact.zzcsz;
            bl2 = zzk.zzln().currentTimeMillis() - l > (Long)zzyr.zzpe().zzd(zzaci2) || !zzawm3.zzur();
        }
        if (!bl2) {
            return;
        }
        if (context == null) {
            zzaxa.zzep((String)"Context not provided to fetch application settings");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)string2) && TextUtils.isEmpty((CharSequence)string3)) {
            zzaxa.zzep((String)"App settings could not be fetched. Required parameters missing");
            return;
        }
        Context context2 = context.getApplicationContext();
        this.zzlj = context2 != null ? context2 : context;
        zzalk<JSONObject, JSONObject> zzalk2 = zzk.zzlt().zzb(this.zzlj, zzbaj2).zza("google.afma.config.fetchAppSettings", zzalp.zzddk, zzalp.zzddk);
        try {
            JSONObject jSONObject = new JSONObject();
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                jSONObject.put("app_id", (Object)string2);
            } else if (!TextUtils.isEmpty((CharSequence)string3)) {
                jSONObject.put("ad_unit_id", (Object)string3);
            }
            jSONObject.put("is_init", bl);
            jSONObject.put("pn", (Object)context.getPackageName());
            zzbbi<JSONObject> zzbbi2 = zzalk2.zzi(jSONObject);
            zzbbi zzbbi3 = zzbas.zza(zzbbi2, zze.zzbra, zzbbn.zzeah);
            if (runnable != null) {
                zzbbi2.zza(runnable, zzbbn.zzeah);
            }
            zzbap.zza(zzbbi3, "ConfigLoader.maybeFetchNewAppSettings");
            return;
        }
        catch (Exception exception) {
            zzaxa.zzc((String)"Error requesting application settings", (Throwable)exception);
            return;
        }
    }
}

