/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.RemoteException;
import com.google.android.gms.ads.initialization.AdapterStatus;
import com.google.android.gms.ads.initialization.InitializationStatus;
import com.google.android.gms.ads.initialization.zza;
import com.google.android.gms.ads.mediation.rtb.RtbAdapter;
import com.google.android.gms.ads.reward.RewardedVideoAd;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzabd;
import com.google.android.gms.internal.ads.zzabe;
import com.google.android.gms.internal.ads.zzabh;
import com.google.android.gms.internal.ads.zzact;
import com.google.android.gms.internal.ads.zzain;
import com.google.android.gms.internal.ads.zzaiv;
import com.google.android.gms.internal.ads.zzaiw;
import com.google.android.gms.internal.ads.zzamj;
import com.google.android.gms.internal.ads.zzamp;
import com.google.android.gms.internal.ads.zzare;
import com.google.android.gms.internal.ads.zzasx;
import com.google.android.gms.internal.ads.zzatk;
import com.google.android.gms.internal.ads.zzbae;
import com.google.android.gms.internal.ads.zzyf;
import com.google.android.gms.internal.ads.zzyl;
import com.google.android.gms.internal.ads.zzyo;
import com.google.android.gms.internal.ads.zzyr;
import com.google.android.gms.internal.ads.zzzz;
import java.util.HashMap;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;

@zzare
public final class zzabc {
    @GuardedBy(value="lock")
    private static zzabc zzcjp;
    private static final Object lock;
    private zzzz zzcjq;
    private RewardedVideoAd zzcjr;
    private InitializationStatus zzcjs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzabc zzqf() {
        Object object = lock;
        synchronized (object) {
            if (zzcjp == null) {
                zzcjp = new zzabc();
            }
            return zzcjp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void zza(Context context, String string, zzabh zzabh2, zza zza2) {
        Object object = lock;
        synchronized (object) {
            if (this.zzcjq != null) {
                return;
            }
            if (context == null) {
                throw new IllegalArgumentException("Context cannot be null.");
            }
            try {
                zzamj.initialize(context, string);
                Context context2 = context;
                Object object2 = zzyr.zzpb();
                Context context3 = context2;
                this.zzcjq = (zzzz)new zzyl((zzyf)object2, context2).zzd(context3, false);
                this.zzcjq.zza(new zzamp());
                this.zzcjq.zza();
                this.zzcjq.zzb(string, ObjectWrapper.wrap((Object)new zzabd(this, context)));
                zzact.initialize(context);
                object2 = zzact.zzcux;
                if (!((Boolean)zzyr.zzpe().zzd(object2)).booleanValue()) {
                    object2 = zzact.zzcvd;
                    if (zzyr.zzpe().zzd(object2).booleanValue()) {
                        return;
                    }
                }
                boolean bl = false;
                if (bl) return;
                zzbae.zzen("Google Mobile Ads SDK initialization functionality unavailable for this session. Ad requests can be made at any time.");
                object2 = this;
                this.zzcjs = new zzabe((zzabc)object2);
            }
            catch (RemoteException remoteException) {
                zzbae.zzd("MobileAdsSettingManager initialization failed", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final RewardedVideoAd getRewardedVideoAdInstance(Context context) {
        Object object = lock;
        synchronized (object) {
            zzamp zzamp2;
            if (this.zzcjr != null) {
                return this.zzcjr;
            }
            zzamp zzamp3 = zzamp2 = new zzamp();
            Context context2 = context;
            zzyf zzyf2 = zzyr.zzpb();
            Context context3 = context2;
            zzasx zzasx2 = (zzasx)new zzyo(zzyf2, context2, zzamp3).zzd(context3, false);
            this.zzcjr = new zzatk(context, zzasx2);
            return this.zzcjr;
        }
    }

    public final void setAppVolume(float f) {
        Preconditions.checkArgument((0.0f <= f && f <= 1.0f ? 1 : 0) != 0, (Object)"The app volume must be a value between 0 and 1 inclusive.");
        Preconditions.checkState((this.zzcjq != null ? 1 : 0) != 0, (Object)"MobileAds.initialize() must be called prior to setting the app volume.");
        try {
            this.zzcjq.setAppVolume(f);
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zzc("Unable to set app volume.", remoteException);
            return;
        }
    }

    public final float zzpq() {
        float f = 1.0f;
        if (this.zzcjq == null) {
            return 1.0f;
        }
        try {
            f = this.zzcjq.zzpq();
        }
        catch (RemoteException remoteException) {
            zzbae.zzc("Unable to get app volume.", remoteException);
        }
        return f;
    }

    public final void setAppMuted(boolean bl) {
        Preconditions.checkState((this.zzcjq != null ? 1 : 0) != 0, (Object)"MobileAds.initialize() must be called prior to setting app muted state.");
        try {
            this.zzcjq.setAppMuted(bl);
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zzc("Unable to set app mute state.", remoteException);
            return;
        }
    }

    public final boolean zzpr() {
        boolean bl = false;
        if (this.zzcjq == null) {
            return false;
        }
        try {
            bl = this.zzcjq.zzpr();
        }
        catch (RemoteException remoteException) {
            zzbae.zzc("Unable to get app mute state.", remoteException);
        }
        return bl;
    }

    public final void openDebugMenu(Context context, String string) {
        Preconditions.checkState((this.zzcjq != null ? 1 : 0) != 0, (Object)"MobileAds.initialize() must be called prior to opening debug menu.");
        try {
            this.zzcjq.zzc(ObjectWrapper.wrap((Object)context), string);
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zzc("Unable to open debug menu.", remoteException);
            return;
        }
    }

    public final String getVersionString() {
        Preconditions.checkState((this.zzcjq != null ? 1 : 0) != 0, (Object)"MobileAds.initialize() must be called prior to getting version string.");
        try {
            return this.zzcjq.getVersionString();
        }
        catch (RemoteException remoteException) {
            zzbae.zzc("Unable to get version string.", remoteException);
            return "";
        }
    }

    public final void registerRtbAdapter(Class<? extends RtbAdapter> clazz) {
        try {
            this.zzcjq.zzbv(clazz.getCanonicalName());
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zzc("Unable to register RtbAdapter", remoteException);
            return;
        }
    }

    public final InitializationStatus getInitializationStatus() {
        Preconditions.checkState((this.zzcjq != null ? 1 : 0) != 0, (Object)"MobileAds.initialize() must be called prior to getting initialization status.");
        try {
            if (this.zzcjs != null) {
                return this.zzcjs;
            }
            List<zzain> list = this.zzcjq.zzps();
            HashMap<String, AdapterStatus> hashMap = new HashMap<String, AdapterStatus>();
            for (zzain zzain2 : list) {
                hashMap.put(zzain2.zzdba, new zzaiv(zzain2.zzdbb ? AdapterStatus.State.READY : AdapterStatus.State.NOT_READY, zzain2.description, zzain2.zzdbc));
            }
            return new zzaiw(hashMap);
        }
        catch (RemoteException remoteException) {
            zzbae.zzen("Unable to get Initialization status.");
            return null;
        }
    }

    private zzabc() {
    }

    static {
        lock = new Object();
    }
}

