/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.support.annotation.GuardedBy;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzav;
import com.google.android.gms.measurement.internal.zzaw;
import com.google.android.gms.measurement.internal.zzax;
import com.google.android.gms.measurement.internal.zzbf;
import com.google.android.gms.measurement.internal.zzbt;
import com.google.android.gms.measurement.internal.zzby;
import com.google.android.gms.measurement.internal.zzct;
import com.google.android.gms.measurement.internal.zzcu;
import com.google.android.gms.measurement.internal.zzt;

public final class zzau
extends zzcu {
    private char zzjp = '\u0000';
    private long zzt = -1L;
    @GuardedBy(value="this")
    private String zzjq;
    private final zzaw zzjr = new zzaw(this, 6, false, false);
    private final zzaw zzjs = new zzaw(this, 6, true, false);
    private final zzaw zzjt = new zzaw(this, 6, false, true);
    private final zzaw zzju = new zzaw(this, 5, false, false);
    private final zzaw zzjv = new zzaw(this, 5, true, false);
    private final zzaw zzjw = new zzaw(this, 5, false, true);
    private final zzaw zzjx = new zzaw(this, 4, false, false);
    private final zzaw zzjy = new zzaw(this, 3, false, false);
    private final zzaw zzjz = new zzaw(this, 2, false, false);

    zzau(zzby zzby2) {
        super(zzby2);
    }

    public final zzaw zzda() {
        return this.zzjr;
    }

    public final zzaw zzdb() {
        return this.zzjs;
    }

    public final zzaw zzdc() {
        return this.zzjt;
    }

    public final zzaw zzdd() {
        return this.zzju;
    }

    public final zzaw zzde() {
        return this.zzjv;
    }

    public final zzaw zzdf() {
        return this.zzjw;
    }

    public final zzaw zzdg() {
        return this.zzjx;
    }

    public final zzaw zzdh() {
        return this.zzjy;
    }

    public final zzaw zzdi() {
        return this.zzjz;
    }

    @Override
    protected final boolean zzak() {
        return false;
    }

    protected static Object zzao(String string) {
        if (string == null) {
            return null;
        }
        return new zzax(string);
    }

    protected final void zza(int n, boolean bl, boolean bl2, String string, Object object, Object object2, Object object3) {
        if (!bl && this.isLoggable(n)) {
            String string2 = zzau.zza(false, string, object, object2, object3);
            this.zza(n, string2);
        }
        if (!bl2 && n >= 5) {
            Object object4 = object3;
            Object object5 = object2;
            Object object6 = object;
            String string3 = string;
            int n2 = n;
            zzau zzau2 = this;
            Preconditions.checkNotNull((Object)string3);
            zzbt zzbt2 = zzau2.zzl.zzek();
            if (zzbt2 == null) {
                zzau2.zza(6, "Scheduler not set. Not logging error/warn");
                return;
            }
            if (!zzbt2.isInitialized()) {
                zzau2.zza(6, "Scheduler not initialized. Not logging error/warn");
                return;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 >= 9) {
                n2 = 8;
            }
            int n3 = n2;
            zzbt2.zza(new zzav(zzau2, n3, string3, object6, object5, object4));
        }
    }

    @VisibleForTesting
    protected final boolean isLoggable(int n) {
        return Log.isLoggable((String)this.zzdj(), (int)n);
    }

    @VisibleForTesting
    protected final void zza(int n, String string) {
        Log.println((int)n, (String)this.zzdj(), (String)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final String zzdj() {
        zzau zzau2 = this;
        synchronized (zzau2) {
            if (this.zzjq == null) {
                this.zzjq = this.zzl.zzeo() != null ? this.zzl.zzeo() : com.google.android.gms.measurement.internal.zzt.zzbo();
            }
            return this.zzjq;
        }
    }

    static String zza(boolean bl, String string, Object object, Object object2, Object object3) {
        if (string == null) {
            string = "";
        }
        String string2 = zzau.zza(bl, object);
        String string3 = zzau.zza(bl, object2);
        String string4 = zzau.zza(bl, object3);
        StringBuilder stringBuilder = new StringBuilder();
        String string5 = "";
        if (!TextUtils.isEmpty((CharSequence)string)) {
            stringBuilder.append(string);
            string5 = ": ";
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            stringBuilder.append(string5);
            stringBuilder.append(string2);
            string5 = ", ";
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            stringBuilder.append(string5);
            stringBuilder.append(string3);
            string5 = ", ";
        }
        if (!TextUtils.isEmpty((CharSequence)string4)) {
            stringBuilder.append(string5);
            stringBuilder.append(string4);
        }
        return stringBuilder.toString();
    }

    @VisibleForTesting
    private static String zza(boolean bl, Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof Integer) {
            object = (long)((Integer)object).intValue();
        }
        if (object instanceof Long) {
            if (!bl) {
                return String.valueOf(object);
            }
            if (Math.abs((Long)object) < 100L) {
                return String.valueOf(object);
            }
            String string = String.valueOf(object).charAt(0) == '-' ? "-" : "";
            String string2 = String.valueOf(Math.abs((Long)object));
            long l = Math.round(Math.pow(10.0, string2.length() - 1));
            long l2 = Math.round(Math.pow(10.0, string2.length()) - 1.0);
            return new StringBuilder(43 + String.valueOf(string).length() + String.valueOf(string).length()).append(string).append(l).append("...").append(string).append(l2).toString();
        }
        if (object instanceof Boolean) {
            return String.valueOf(object);
        }
        if (object instanceof Throwable) {
            Throwable throwable = (Throwable)object;
            StringBuilder stringBuilder = new StringBuilder(bl ? throwable.getClass().getName() : throwable.toString());
            String string = zzau.zzap(zzby.class.getCanonicalName());
            for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                String string3;
                if (stackTraceElement.isNativeMethod() || (string3 = stackTraceElement.getClassName()) == null || !zzau.zzap(string3).equals(string)) continue;
                stringBuilder.append(": ");
                stringBuilder.append(stackTraceElement);
                break;
            }
            return stringBuilder.toString();
        }
        if (object instanceof zzax) {
            return zzax.zza((zzax)object);
        }
        if (bl) {
            return "-";
        }
        return String.valueOf(object);
    }

    private static String zzap(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public final String zzdk() {
        Pair<String, Long> pair = ((zzct)this).zzae().zzla.zzeb();
        if (pair == null || pair == zzbf.zzky) {
            return null;
        }
        String string = String.valueOf(pair.second);
        String string2 = (String)pair.first;
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(":").append(string2).toString();
    }

    static /* synthetic */ char zza(zzau zzau2) {
        return zzau2.zzjp;
    }

    static /* synthetic */ char zza(zzau zzau2, char c) {
        zzau2.zzjp = c;
        return zzau2.zzjp;
    }

    static /* synthetic */ long zzb(zzau zzau2) {
        return zzau2.zzt;
    }

    static /* synthetic */ long zza(zzau zzau2, long l) {
        zzau2.zzt = l;
        return zzau2.zzt;
    }
}

