/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.AuthenticatorException;
import android.accounts.OperationCanceledException;
import android.content.Context;
import android.content.pm.PackageManager;
import android.support.annotation.WorkerThread;
import android.support.v4.content.ContextCompat;
import com.google.android.gms.measurement.internal.zzby;
import com.google.android.gms.measurement.internal.zzct;
import com.google.android.gms.measurement.internal.zzcu;
import com.google.android.gms.measurement.internal.zzq;
import java.io.IOException;
import java.util.Calendar;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public final class zzad
extends zzcu {
    private long zzew;
    private String zzex;
    private Boolean zzey;
    private AccountManager zzez;
    private Boolean zzfa;
    private long zzfb;

    zzad(zzby zzby2) {
        super(zzby2);
    }

    @Override
    protected final boolean zzak() {
        Calendar calendar = Calendar.getInstance();
        this.zzew = TimeUnit.MINUTES.convert(calendar.get(15) + calendar.get(16), TimeUnit.MILLISECONDS);
        Locale locale = Locale.getDefault();
        String string = locale.getLanguage().toLowerCase(Locale.ENGLISH);
        String string2 = locale.getCountry().toLowerCase(Locale.ENGLISH);
        this.zzex = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("-").append(string2).toString();
        return false;
    }

    public final long zzco() {
        this.zzah();
        return this.zzew;
    }

    public final String zzcp() {
        this.zzah();
        return this.zzex;
    }

    public final boolean zzj(Context context) {
        if (this.zzey == null) {
            zzq zzq2 = ((zzct)this).zzag();
            this.zzey = false;
            try {
                PackageManager packageManager = context.getPackageManager();
                if (packageManager != null) {
                    packageManager.getPackageInfo("com.google.android.gms", 128);
                    this.zzey = true;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        }
        return this.zzey;
    }

    @WorkerThread
    final long zzcq() {
        ((zzct)this).zzq();
        return this.zzfb;
    }

    @WorkerThread
    final void zzcr() {
        ((zzct)this).zzq();
        this.zzfa = null;
        this.zzfb = 0L;
    }

    @WorkerThread
    final boolean zzcs() {
        ((zzct)this).zzq();
        long l = ((zzct)this).zzz().currentTimeMillis();
        if (l - this.zzfb > 86400000L) {
            this.zzfa = null;
        }
        if (this.zzfa != null) {
            return this.zzfa;
        }
        if (ContextCompat.checkSelfPermission((Context)((zzct)this).getContext(), (String)"android.permission.GET_ACCOUNTS") != 0) {
            ((zzct)this).zzad().zzde().zzaq("Permission error checking for dasher/unicorn accounts");
            this.zzfb = l;
            this.zzfa = false;
            return false;
        }
        if (this.zzez == null) {
            this.zzez = AccountManager.get((Context)((zzct)this).getContext());
        }
        try {
            Account[] accountArray = (Account[])this.zzez.getAccountsByTypeAndFeatures("com.google", new String[]{"service_HOSTED"}, null, null).getResult();
            if (accountArray != null && accountArray.length > 0) {
                this.zzfa = true;
                this.zzfb = l;
                return true;
            }
            accountArray = (Account[])this.zzez.getAccountsByTypeAndFeatures("com.google", new String[]{"service_uca"}, null, null).getResult();
            if (accountArray != null && accountArray.length > 0) {
                this.zzfa = true;
                this.zzfb = l;
                return true;
            }
        }
        catch (AuthenticatorException | OperationCanceledException | IOException throwable) {
            ((zzct)this).zzad().zzdb().zza("Exception checking account types", throwable);
        }
        this.zzfb = l;
        this.zzfa = false;
        return false;
    }
}

