/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zzdj;
import com.google.android.gms.internal.measurement.zzfb;
import com.google.android.gms.internal.measurement.zzfg;
import com.google.android.gms.internal.measurement.zzgt;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzew
extends zzdj<Float>
implements zzfg<Float>,
zzgt,
RandomAccess {
    private static final zzew zzagj = new zzew(new float[0], 0);
    private float[] zzagk;
    private int size;

    zzew() {
        this(new float[10], 0);
    }

    private zzew(float[] fArray, int n) {
        this.zzagk = fArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzka();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzagk, n2, this.zzagk, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzew)) {
            return super.equals(object);
        }
        zzew zzew2 = (zzew)object;
        if (this.size != zzew2.size) {
            return false;
        }
        float[] fArray = zzew2.zzagk;
        for (int i = 0; i < this.size; ++i) {
            if (Float.floatToIntBits(this.zzagk[i]) == Float.floatToIntBits(fArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + Float.floatToIntBits(this.zzagk[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzc(float f) {
        this.zzc(this.size, f);
    }

    private final void zzc(int n, float f) {
        this.zzka();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzp(n));
        }
        if (this.size < this.zzagk.length) {
            System.arraycopy(this.zzagk, n, this.zzagk, n + 1, this.size - n);
        } else {
            float[] fArray = new float[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzagk, 0, fArray, 0, n);
            System.arraycopy(this.zzagk, n, fArray, n + 1, this.size - n);
            this.zzagk = fArray;
        }
        this.zzagk[n] = f;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Float> collection) {
        this.zzka();
        zzfb.checkNotNull(collection);
        if (!(collection instanceof zzew)) {
            return super.addAll(collection);
        }
        zzew zzew2 = (zzew)collection;
        if (zzew2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzew2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzew2.size;
        if (n > this.zzagk.length) {
            this.zzagk = Arrays.copyOf(this.zzagk, n);
        }
        System.arraycopy(zzew2.zzagk, 0, this.zzagk, this.size, zzew2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzka();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(Float.valueOf(this.zzagk[i]))) continue;
            System.arraycopy(this.zzagk, i + 1, this.zzagk, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzo(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzp(n));
        }
    }

    private final String zzp(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Float f = (Float)object;
        float f2 = f.floatValue();
        zzew zzew2 = this;
        zzew2.zzka();
        zzew2.zzo(n);
        float f3 = zzew2.zzagk[n];
        zzew2.zzagk[n] = f2;
        return Float.valueOf(f3);
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzew zzew2 = this;
        zzew2.zzka();
        zzew2.zzo(n);
        float f = zzew2.zzagk[n];
        if (n < zzew2.size - 1) {
            System.arraycopy(zzew2.zzagk, n + 1, zzew2.zzagk, n, zzew2.size - n - 1);
        }
        --zzew2.size;
        ++zzew2.modCount;
        return Float.valueOf(f);
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Float f = (Float)object;
        this.zzc(n, f.floatValue());
    }

    @Override
    public final /* synthetic */ zzfg zzq(int n) {
        int n2 = n;
        zzew zzew2 = this;
        if (n2 < zzew2.size) {
            throw new IllegalArgumentException();
        }
        return new zzew(Arrays.copyOf(zzew2.zzagk, n2), zzew2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzew zzew2 = this;
        zzew2.zzo(n);
        return Float.valueOf(zzew2.zzagk[n]);
    }

    static {
        zzagj.zzjz();
    }
}

